/**
 * 
 */
package gov.va.med.mhv.integration.phr.service.cds;

import gov.va.med.mhv.cds.template.mhvlabread40011.ClinicalData;
import gov.va.med.mhv.integration.phr.service.ClinicalDataDocument;
import gov.va.med.mhv.integration.phr.service.ErrorSection;

/**
 * @author DNS
 *
 */
public class ChemistryClinicalDataDocument implements ClinicalDataDocument {

	private ClinicalData chemistryClinicalData = null;
	
	public ChemistryClinicalDataDocument(ClinicalData allergyClinicalData) {
		if(allergyClinicalData == null) {
			throw new IllegalArgumentException("Allergy clinical data is null.");
		}
		this.chemistryClinicalData = allergyClinicalData;
	}
	
	@Override
	public String getRequestedNationalId() {
		return this.chemistryClinicalData.getPatient().get(0).getRequestedNationalId();
	}
	
	@Override
	public ErrorSection getErrorSection() {
		if(this.chemistryClinicalData.getErrorSection() != null) {
			return new ChemistryErrorSection(this.chemistryClinicalData.getErrorSection());
		}
		
		return null;
	}
	
	@Override
	public Boolean isValid() {
		return (this.chemistryClinicalData.getPatient().size() > 0 
				&& this.getRequestedNationalId() != null);
	}
	
	@Override
	public Object unwrap() {
		return this.chemistryClinicalData;
	}
}
